    	<?php

    	//@author: Higinio Maeztu
		//NOTA IMPORTANTE: RELLENAD ANTES EL config.php

		//pide en sectigo los certificados que le indiquemos, para lo que es neceario rellenear el array orders
    	//Example: $orders = array("12928992", "12911363");
		$orders = array();

		error_reporting(E_ALL);
		ini_set('display_errors',1);
		ini_set('error_reporting', E_ALL);
		ini_set('display_startup_errors',1);



		require_once("config.php");
		require_once("array_certs.php");

		////// SECTIGO CREDENCIALS
		$sectigoCustomerUri= "RedIRIS";
		$customHeaders = array(
		    'customerUri:'.$sectigoCustomerUri,
		    'login:'.$sectigoUser,
		    'password:'.$sectigoPass
		);
		$urlEnroll =  "https://cert-manager.com/api/ssl/v1/enroll";    
		////// SECTIGO CREDENCIALS




		$url2 = "https://cert-manager.com/api/organization/v1";
		$organizations = json_decode(CurlGetSectigo($url2, $customHeaders));
		foreach($organizations as $organization){
			//Sectigo organization ID
			$orgID = $organization->id;
		}

		foreach($orders as $orderID){

			$order = CurlGetDG($digicertKey,"https://www.digicert.com/services/v2/order/certificate/$orderID");
			$certDigicert = json_decode($order);
			    
			$open=str_replace(PHP_EOL,'',$certDigicert->certificate->csr);
		
			
			 if($relations_types [$certDigicert->product->name_id] == "4575"){
			 	$data = json_encode(array ("commonName"=>$certDigicert->certificate->common_name,"subjAltNames"=>implode(",",$certDigicert->certificate->dns_names), "orgId" => $orgID,"term"=>($certDigicert->validity_years * 365), 
				"certType"=>$relations_types [$certDigicert->product->name_id],"externalRequester"=>$certDigicert->user->email,"comments"=>"migration","csr" => $open));
			 }
			 else{
				$data = json_encode(array ("commonName"=>$certDigicert->certificate->common_name, "orgId" => $orgID,"term"=>($certDigicert->validity_years * 365), 
				"certType"=>$relations_types [$certDigicert->product->name_id],"externalRequester"=>$certDigicert->user->email,"comments"=>"migration","csr" => $open)); 	
			 }
			

			
		    //POST approve delegation of domain. https://cert-manager.com/api/domain/v1/$id/delegation/approve. Paramas 'orgId' => $orgId
		    $return = CurlPostSectigo($urlEnroll, $customHeaders, $data);
		    $return = json_decode($return);
		    if(isset($return->sslId)){
		    	
		    	$sslId = $return->sslId;
		    	$mensaje = '<div class="alert alert-success"><strong>Success!</strong> Cert requested correctly '.$certDigicert->certificate->common_name.' <b>sslId</b>:<b>'.$sslId.'</b></div>';
		    }
		    else{
		    	$mensaje = '<div class="alert alert-danger"><strong>Error!</strong> An error has happened: '. json_encode($return).' for '.$certDigicert->certificate->common_name.'</div>';
		    } 

		    echo $mensaje."<br>";  
		}




		// FUNCTIONS
		function CurlGetDG($api_key, $url){
			$headers = array(
				"X-DC-DEVKEY: $api_key",
				"Content-Type: application/json"
			);

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POST, false);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
			$response = curl_exec($ch); 

			curl_close($ch);
			return $response;
		}

		function CurlGetSectigo($url, $headers){
	        $ch = curl_init($url);
	        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	        $result = curl_exec($ch);
	        curl_close ($ch);
	        return $result;
	    }

		function CurlPostSectigo($url, $headers, $params){
		        $headers[]='Content-Type:application/json';
		        $headers[]='Content-Length:'.strlen($params);
		        $ch = curl_init($url);
		        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($ch,CURLOPT_POST, TRUE);
		        curl_setopt($ch,CURLOPT_POSTFIELDS, $params);
		        $result = curl_exec($ch);
		        print_r(curl_error($ch));
		        curl_close ($ch);
		        return $result;
		    }

		?>

